<?php
session_start();

if (isset($_GET['reset'])) {
    unset($_SESSION['chat']);
    unset($_SESSION['pedido']);
    header("Location: " . strtok($_SERVER["REQUEST_URI"], '?'));
    exit;
}

if (!isset($_SESSION['chat'])) {
    $_SESSION['chat'] = [
        ['role' => 'system', 'content' =>
            "Você é um atendente virtual da Esfirra da Hora. Sua missão é atender pedidos de esfirra e refrigerante, somar os valores e informar o total com a taxa de entrega, se for o caso.

Cardápio de Esfirras (R$5,00 cada):
- Carne
- Queijo
- Frango
- Calabresa
- Bacon
- Quatro Queijos

Refrigerantes:
- Cola 2L - R$13,00
- Cola 1,5L - R$10,00
- Fanta 2L - R$13,00
- Fanta 1,5L - R$10,00
- Sprite 2L - R$13,00
- Sprite 1,5L - R$10,00

Taxa de entrega: R$10,00

Fluxo:
1. Cumprimente e peça o nome do cliente.
2. Pergunte quais sabores de esfirra ele deseja e quantas de cada.
3. Pergunte se quer refrigerante, qual sabor e volume.
4. Pergunte se o pedido é para entrega ou retirada.
5. Se for entrega, peça endereço e telefone.
6. Pergunte se o cliente confirma o pedido.
7. Se for confirmado, mostre o resumo e o valor total.
8. Informe o valor final e agradeça.

Você deve simular o cálculo do total com base nas respostas do cliente. Seja simpático e objetivo!"]
    ];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['mensagem'])) {
    $_SESSION['chat'][] = ['role' => 'user', 'content' => $_POST['mensagem']];

    // Processar o pedido
    if (isset($_POST['mensagem'])) {
        if (strpos($_POST['mensagem'], 'esfirra') !== false || strpos($_POST['mensagem'], 'refrigerante') !== false) {
            // Guardar os detalhes do pedido
            if (!isset($_SESSION['pedido'])) {
                $_SESSION['pedido'] = [];
            }
            
            // Adicionando esfirras e refrigerantes
            if (strpos($_POST['mensagem'], 'esfirra') !== false) {
                $_SESSION['pedido']['esfirra'][] = $_POST['mensagem'];
            }
            if (strpos($_POST['mensagem'], 'refrigerante') !== false) {
                $_SESSION['pedido']['refrigerante'][] = $_POST['mensagem'];
            }
        }
        
        // Pergunta de confirmação do pedido
        if (strpos($_POST['mensagem'], 'confirmar') !== false) {
            $_SESSION['chat'][] = ['role' => 'assistant', 'content' => gerarResumoPedido()];
            $_SESSION['chat'][] = ['role' => 'assistant', 'content' => "Seu pedido foi confirmado!"];
            unset($_SESSION['pedido']); // Limpa o pedido após confirmação
        }
    }

    $curl = curl_init("https://openrouter.ai/api/v1/chat/completions");
    curl_setopt_array($curl, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            "Authorization: Bearer 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",
            "Content-Type: application/json"
        ],
        CURLOPT_POSTFIELDS => json_encode([
            "model" => "openai/gpt-3.5-turbo",
            "messages" => $_SESSION['chat']
        ])
    ]);

    $response = curl_exec($curl);
    $resposta = json_decode($response, true);
    $respostaTexto = $resposta['choices'][0]['message']['content'] ?? 'Erro na resposta da IA.';

    $_SESSION['chat'][] = ['role' => 'assistant', 'content' => $respostaTexto];
}

function gerarResumoPedido() {
    $resumo = "Resumo do Pedido:\n";
    $total = 0;

    if (isset($_SESSION['pedido']['esfirra'])) {
        $totalEsfirra = count($_SESSION['pedido']['esfirra']) * 5;
        $resumo .= "Esfirras: " . count($_SESSION['pedido']['esfirra']) . " x R$5,00 = R$" . $totalEsfirra . "\n";
        $total += $totalEsfirra;
    }

    if (isset($_SESSION['pedido']['refrigerante'])) {
        $totalRefrigerante = count($_SESSION['pedido']['refrigerante']) * 10; // Exemplo de preço médio
        $resumo .= "Refrigerantes: " . count($_SESSION['pedido']['refrigerante']) . " x R$10,00 = R$" . $totalRefrigerante . "\n";
        $total += $totalRefrigerante;
    }

    $resumo .= "Total: R$" . $total . "\n";

    return $resumo;
}

?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Chat da Esfirraria</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f1f1f1;
            font-family: 'Segoe UI', sans-serif;
            background-image: url(fundo2.jpg);
        }
        .chat-container {
            max-width: 600px;
            margin: 30px auto;
            background-color: #fff;
            border-radius: 12px;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
            overflow: hidden;
            display: flex;
            flex-direction: column;
            height: 90vh;
        }
        .chat-header {
            background-color: #f0f2f5; /* Cor do WhatsApp */
            color: #000000;
            padding: 15px;
            font-size: 1.2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .chat-body {
            flex: 0.9;
            overflow-y: auto;
            padding: 15px;
            background-color: #e5ddd5; /* Cor clara de fundo */
            background-image: url(fundo.png);
        }
        .chat-msg {
            margin-bottom: 12px;
            max-width: 60%;
            padding: 7px 14px;
            border-radius: 10px;
            word-wrap: break-word;
            word-wrap: break-word;
            /*white-space: pre-wrap;*/
        }
        .chat-user {
            background-color: #d9fdd3; /* Azul claro, cor do WhatsApp */
            color: #000000;
            align-self: flex-end;
            border-bottom-right-radius: 0;
            margin-left: 40%;
        }
        .chat-assistant {
            background-color: #ffffff; /* Cor mais clara, similar ao fundo do WhatsApp */
            color: #333;
            align-self: flex-start;
            border-bottom-left-radius: 0;
        }
        .chat-footer {
            display: flex;
            padding: 10px;
            border-top: 1px solid #ccc;
        }
        .chat-footer input {
            flex: 1;
            padding: 10px;
            border-radius: 20px;
            border: 1px solid #ccc;
            margin-right: 10px;
        }
        .chat-footer button {
            border: none;
            border-radius: 20px;
            padding: 10px 20px;
            background-color: #25d366; /* Cor do WhatsApp */
            color: white;
        }

        @media (max-width: 768px) {
            .chat-container {
                margin: 0;
                height: 100vh;
                border-radius: 0;
            }
        }
    </style>
</head>
<body>
<div class="chat-container">
    <div class="chat-header">
        🥙 Esfirra da Hora
        <a href="?reset=1" class="btn btn-sm btn-light text-danger">Limpar</a>
    </div>
    <div class="chat-body" id="chat-body">
        <?php foreach ($_SESSION['chat'] as $mensagem): ?>
            <?php if ($mensagem['role'] !== 'system'): ?>
                <div class="chat-msg <?= $mensagem['role'] === 'user' ? 'chat-user' : 'chat-assistant' ?>">
                    <?= nl2br(htmlspecialchars($mensagem['content'])) ?>
                </div>
            <?php endif; ?>
        <?php endforeach; ?>
    </div>
    <form method="post" class="chat-footer">
        <input type="text" name="mensagem" placeholder="Digite sua mensagem..." required autocomplete="off">
        <button type="submit">Enviar</button>
    </form>
</div>

<script>
    const body = document.getElementById('chat-body');
    body.scrollTop = body.scrollHeight;
</script>
</body>
</html>
