<?php
session_start();

// ========== CONFIGURAÇÃO DO BANCO ==========
$host = 'localhost';
$db = 'tbadigital_chatbot';
$user = 'tbadigital_chatbot';
$pass = 'Sa@10270523$';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    echo "Erro na conexão com o banco de dados: " . $e->getMessage();
    exit;
}

// ========== FUNÇÕES ==========
function buscarProduto($nome, $pdo) {
    $stmt = $pdo->prepare("SELECT * FROM produtos WHERE nome LIKE ?");
    $stmt->execute(["%$nome%"]);
    return $stmt->fetch();
}

function gerarResumoPedido($mensagem, $pdo) {
    $produtos = explode(',', $mensagem);
    $resumo = [];
    $total = 0.0;

    foreach ($produtos as $item) {
        preg_match('/(\d+)\s*x\s*(.+)/i', trim($item), $matches);
        if ($matches) {
            $quantidade = (int) $matches[1];
            $nomeProduto = trim($matches[2]);
            $produto = buscarProduto($nomeProduto, $pdo);

            if ($produto) {
                $subtotal = $quantidade * $produto['preco'];
                $total += $subtotal;
                $resumo[] = "{$quantidade}x {$produto['nome']} (R$ " . number_format($produto['preco'], 2, ',', '.') . ") = R$ " . number_format($subtotal, 2, ',', '.');
            } else {
                $resumo[] = "{$quantidade}x {$nomeProduto} - Produto não encontrado";
            }
        } else {
            $resumo[] = "Formato inválido: " . trim($item);
        }
    }

    $resumo[] = "Total: R$ " . number_format($total, 2, ',', '.');
    return implode("\n", $resumo);
}

function salvarPedido($mensagem, $pdo) {
    $produtos = explode(',', $mensagem);
    $pedidoId = null;
    $total = 0.0;

    foreach ($produtos as $item) {
        preg_match('/(\d+)\s*x\s*(.+)/i', trim($item), $matches);
        if ($matches) {
            $quantidade = (int) $matches[1];
            $nomeProduto = trim($matches[2]);
            $produto = buscarProduto($nomeProduto, $pdo);

            if ($produto) {
                $subtotal = $quantidade * $produto['preco'];
                $total += $subtotal;

                if (!$pedidoId) {
                    $stmt = $pdo->prepare("INSERT INTO pedidos (valor_total, data_pedido) VALUES (?, NOW())");
                    $stmt->execute([0]);
                    $pedidoId = $pdo->lastInsertId();
                }

                $stmt = $pdo->prepare("INSERT INTO itens_pedido (pedido_id, produto_id, quantidade, preco_unitario) VALUES (?, ?, ?, ?)");
                $stmt->execute([$pedidoId, $produto['id'], $quantidade, $produto['preco']]);
            }
        }
    }

    if ($pedidoId) {
        $stmt = $pdo->prepare("UPDATE pedidos SET valor_total = ? WHERE id = ?");
        $stmt->execute([$total, $pedidoId]);
        return "Pedido salvo com sucesso! Número: {$pedidoId}";
    } else {
        return "Erro ao salvar o pedido. Verifique os produtos.";
    }
}

function consultarOpenRouter($prompt) {
    $apiKey = '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'; // Trocar pela sua chave real

    $data = [
        "model" => "openrouter/openchat",
        "messages" => [
            ["role" => "system", "content" => "Você é um atendente virtual da Esfirra da Hora. Sua missão é atender pedidos de esfirra e refrigerante, somar os valores e informar o total com a taxa de entrega, se for o caso.

                Taxa de entrega: R$10,00
                
                Fluxo:
                1. Cumprimente e peça o nome do cliente.
                2. Pergunte quais sabores de esfirra ele deseja e quantas de cada.
                3. Pergunte se quer refrigerante, qual sabor e volume.
                4. Pergunte se o pedido é para entrega ou retirada.
                5. Se for entrega, peça endereço e telefone.
                6. Pergunte se o cliente confirma o pedido.
                7. Se for confirmado, mostre o resumo e o valor total.
                8. Informe o valor final e agradeça.
                
                Você deve simular o cálculo do total com base nas respostas do cliente. Seja simpático e objetivo!"],
            ["role" => "user", "content" => $prompt]
        ]
    ];

    $ch = curl_init('https://openrouter.ai/api/v1/chat/completions');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $apiKey,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    $response = curl_exec($ch);
    curl_close($ch);

    $json = json_decode($response, true);
    return $json['choices'][0]['message']['content'] ?? "Erro na resposta da IA.";
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Chat da Esfirraria</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f1f1f1;
            font-family: 'Segoe UI', sans-serif;
            background-image: url(fundo2.jpg);
        }
        .chat-container {
            max-width: 600px;
            margin: 30px auto;
            background-color: #fff;
            border-radius: 12px;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
            overflow: hidden;
            display: flex;
            flex-direction: column;
            height: 90vh;
        }
        .chat-header {
            background-color: #f0f2f5; /* Cor do WhatsApp */
            color: #000000;
            padding: 15px;
            font-size: 1.2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .chat-body {
            flex: 0.9;
            overflow-y: auto;
            padding: 15px;
            background-color: #e5ddd5; /* Cor clara de fundo */
            background-image: url(fundo.png);
        }
        .chat-msg {
            margin-bottom: 12px;
            max-width: 60%;
            padding: 7px 14px;
            border-radius: 10px;
            word-wrap: break-word;
            word-wrap: break-word;
            /*white-space: pre-wrap;*/
        }
        .chat-user {
            background-color: #d9fdd3; /* Azul claro, cor do WhatsApp */
            color: #000000;
            align-self: flex-end;
            border-bottom-right-radius: 0;
            margin-left: 40%;
        }
        .chat-assistant {
            background-color: #ffffff; /* Cor mais clara, similar ao fundo do WhatsApp */
            color: #333;
            align-self: flex-start;
            border-bottom-left-radius: 0;
        }
        .chat-footer {
            display: flex;
            padding: 10px;
            border-top: 1px solid #ccc;
        }
        .chat-footer input {
            flex: 1;
            padding: 10px;
            border-radius: 20px;
            border: 1px solid #ccc;
            margin-right: 10px;
        }
        .chat-footer button {
            border: none;
            border-radius: 20px;
            padding: 10px 20px;
            background-color: #25d366; /* Cor do WhatsApp */
            color: white;
        }

        @media (max-width: 768px) {
            .chat-container {
                margin: 0;
                height: 100vh;
                border-radius: 0;
            }
        }
    </style>
</head>
<body>
<div class="chat-container">
    <div class="chat-header">
        🥙 Esfirra da Hora
        <a href="?reset=1" class="btn btn-sm btn-light text-danger">Limpar</a>
    </div>
    <div class="chat-body" id="chatBox">
        <div class="message bot"><strong>Bot:</strong> Olá! Envie seu pedido</em></div>
    </div>

     <form method="post" class="chat-footer">
        <input type="text" name="mensagem" id="mensagem" placeholder="Digite sua mensagem..." autocomplete="off" required />
        <button type="submit">Enviar</button>
    </form>
</div>

<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $mensagem = trim($_POST['mensagem']);
    echo "<script>
        const box = document.getElementById('chatBox');
        box.innerHTML += `<div class='message user'><strong>Você:</strong> {$mensagem}</div>`;
    </script>";

    if (stripos($mensagem, 'confirmar') !== false) {
        $resposta = salvarPedido($_SESSION['ultimo_pedido'] ?? '', $pdo);
    } else {
        $resumo = gerarResumoPedido($mensagem, $pdo);
        $_SESSION['ultimo_pedido'] = $mensagem;
        $resposta = $resumo . "\n\nDigite *confirmar* para finalizar o pedido.";
    }

    // Opcional: adicionar resposta da IA no final
    $ia = consultarOpenRouter($mensagem);
    $resposta .= "\n\n🧠 IA: " . $ia;

    echo "<script>
        box.innerHTML += `<div class='message bot'><strong>Bot:</strong><pre>" . addslashes($resposta) . "</pre></div>`;
        box.scrollTop = box.scrollHeight;
    </script>";
}
?>
</body>
</html>
